<?php
require('../config_session.php');
require('../function_colors.php');

if(!canColor()){
	die();
}
?>
<div class="modal_content">
	<div class="preview_zone">
		<p class="label"><?php echo $lang['preview']; ?></p>
		<p id="preview_text" class="<?php echo myBubbleColor($data); ?>">Lorem ipsum dolor sit amet. </p>
	</div>
	<div class="color_choices" data="<?php echo $data['bccolor']; ?>">
			<?php if(canGrad() || canNeon()){ ?>
			<div class="reg_menu_container">		
				<div class="reg_menu">
					<ul>
						<li class="reg_menu_item rselected" data="color_tab" data-z="reg_color"><?php echo $lang['color']; ?></li>
						<?php if(canNeon()){ ?>
						<li class="reg_menu_item" data="color_tab" data-z="neon_color"><?php echo $lang['neon']; ?></li>
						<?php } ?>
						<?php if(canGrad()){ ?>
						<li class="reg_menu_item" data="color_tab" data-z="grad_color"><?php echo $lang['gradient']; ?></li>
						<?php } ?>
					</ul>
				</div>
			</div>
			<?php } ?>
			<div id="color_tab">
				<div id="reg_color" class="reg_zone vpad5">
					<?php echo bubbleColorChoice($data['bccolor'], 2); ?>
					<div class="clear"></div>
				</div>
				<?php if(canGrad()){ ?>
				<div id="grad_color" class="reg_zone vpad5 hide_zone">
					<?php echo bubbleGradChoice($data['bccolor'], 2); ?>
					<div class="clear"></div>
				</div>
				<?php } ?>
				<?php if(canNeon()){ ?>
				<div id="neon_color" class="reg_zone vpad5 hide_zone">
					<?php echo bubbleNeonChoice($data['bccolor'], 2); ?>
					<div class="clear"></div>
				</div>
				<?php } ?>
			</div>
			<div class="clear"></div>
	</div>
	<div>
		<div class="btable">
			<div class="bcell_mid">
				<div class="setting_element">
					<p class="label"><?php echo $lang['font_style']; ?></p>
					<select id="boldit">
						<?php echo listFontStyle($data['bcbold']); ?>
					</select>
					<?php if(!canFont()){ ?>
					<input id="fontit" value="" class="hidden"/>
					<?php } ?>
				</div>
			</div>
			<?php if(canFont()){ ?>
			<div class="bcell_mid pwidth10">
			</div>
			<div class="bcell_mid">
				<div class="setting_element">
					<p class="label"><?php echo $lang['font']; ?></p>
					<select id="fontit">
						<?php echo listFont($data['bcfont']); ?>
					</select>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</div>
<div class="modal_control">
	<button onclick="saveColor();" class="reg_button theme_btn"><i class="fa fa-save"></i> <?php echo $lang['save']; ?></button>
</div>